/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.util.ServerCommandUtil;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PacketDeletePlayerItem
extends PacketJei {
    private final ItemStack itemStack;

    public PacketDeletePlayerItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.DELETE_ITEM;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        IPlatformRegistry<Item> registry = Services.PLATFORM.getRegistry(Registry.f_122904_);
        int itemId = registry.getId(this.itemStack.m_41720_());
        buf.m_130130_(itemId);
    }

    public static void readPacketData(ServerPacketData data) {
        ItemStack playerItem;
        IPlatformRegistry registry = Services.PLATFORM.getRegistry(Registry.f_122904_);
        FriendlyByteBuf buf = data.buf();
        ServerPacketContext context = data.context();
        ServerPlayer player = context.player();
        IServerConfig serverConfig = context.serverConfig();
        int itemId = buf.m_130242_();
        Item item = (Item)registry.getValue(itemId);
        if (ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig) && (playerItem = player.f_36096_.m_142621_()).m_41720_() == item) {
            player.f_36096_.m_142503_(ItemStack.f_41583_);
        }
    }
}

